
<?php
// Include header
include 'headeradmin.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Include the centralized database config file
include 'config.php';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if user is logged in and has status 2
if (!isset($_SESSION['user_id']) || $_SESSION['status'] != 2) {
    header('Location: login.php');
    exit();
}

// Fetch user statistics
$user_count_query = "SELECT COUNT(*) AS total_users FROM users";
$investment_sum_query = "SELECT SUM(investment) AS total_investments FROM users";

$user_count_result = $conn->query($user_count_query);
if (!$user_count_result) {
    die("Error fetching user count: " . $conn->error);
}

$investment_sum_result = $conn->query($investment_sum_query);
if (!$investment_sum_result) {
    die("Error fetching investment sum: " . $conn->error);
}

$user_count = $user_count_result->fetch_assoc()['total_users'];
$investment_sum = $investment_sum_result->fetch_assoc()['total_investments'];

// Fetch user data
$user_data_query = "SELECT id, username, email, contact_number, full_name, mt5username, investment, balance, profit, online FROM users";
$user_data_result = $conn->query($user_data_query);
if (!$user_data_result) {
    die("Error fetching user data: " . $conn->error);
}


// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch statistics from the appropriate tables
$queries = [
    'global_profit_query' => "SELECT SUM(profit) AS total_profit FROM userinfo",
    'take_home_profit_query' => "SELECT 0.25 * SUM(profit) AS take_home_profit FROM userinfo",
    'global_balance_query' => "SELECT SUM(balance) AS total_balance FROM userinfo",
    'traders_online_query' => "SELECT COUNT(*) AS total_online FROM users WHERE status = 1",
    'total_invested_query' => "SELECT SUM(investment) AS total_invested FROM users",
    'total_investors_query' => "SELECT COUNT(*) AS total_investors FROM users",

];

$results = [];

foreach ($queries as $key => $query) {
    $result = $conn->query($query);
    if (!$result) {
        die("Error fetching statistics for query '$key': " . $conn->error);
    }
    $results[$key] = $result->fetch_assoc();
}

// Extract results
$global_profit = $results['global_profit_query']['total_profit'];
$take_home_profit = $results['take_home_profit_query']['take_home_profit'];
$global_balance = $results['global_balance_query']['total_balance'];
$traders_online = $results['traders_online_query']['total_online'];
$total_invested = $results['total_invested_query']['total_invested'];
$total_investors = $results['total_investors_query']['total_investors'];


// Close database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
    .body {
        color: #c5b170;   
    }


    </style>
</head>

<body>

<div class="r1">

    <div class="container"><br><br><br>
<h2>Overall Statistics</h2>

<style>
.container {
    margin-top: 100px;
}
/* Container for chart and sticky note */
.chart-and-note {
    display: flex;
    align-items: flex-start;
    width: 100%; /* Ensures it takes up available space */
    max-width: 1200px; /* Adjust as needed for layout */
}

/* Styling for the chart */
#statsChart {
    flex: 1;
    margin-right: 20px; /* Space between chart and sticky note */
}

/* Sticky note styling */
.sticky-note {
    background-color: rgba(50, 50, 50, 0.2); /* Dark grey with slight transparency */
    border: 2px solid #555; /* Slightly lighter grey border */
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.6); /* Deep shadow */
    border-radius: 10px;
    padding: 20px;
    width: 300px;
    height: 370px;
    color: #d7d1ac; /* Light gold text */
    display: flex;
    flex-direction: column;
}

/* Sticky note textarea styling */
.sticky-note textarea {
    width: 100%;
    height: 80%;
    background-color: transparent;
    border: none;
    color: #d7d1ac; /* Light gold text */
    font-size: 16px;
    resize: none;
}

/* Sticky note textarea focus styling */
.sticky-note textarea:focus {
    outline: none;
}

/* Sticky note button styling */
.sticky-note button {
    background: #152525; /* Dark background */
    color: #b2ac8a; /* Light beige text */
    border: 1px solid #b2ac8a; /* Border to match text color */
    padding: 10px 15px;
    border-radius: 20px;
    cursor: pointer;
    margin-top: 10px;
    transition: background-color 0.3s ease; /* Smooth background color transition */
}

/* Sticky note button hover styling */
.sticky-note button:hover {
    background-color: #093c31; /* Darker greenish shade for hover */
}

@media (max-width: 768px) { /* Adjust the breakpoint as needed */
    .sticky-note {
        display: none;
    }
}
</style>







    <script>
        function saveNote() {
            const noteText = document.getElementById('noteText').value;
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'save_note.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = function() {
                if (xhr.status === 200) {
                    alert('Note saved successfully!');
                } else {
                    alert('Failed to save note');
                }
            };
            xhr.send('note=' + encodeURIComponent(noteText));
        }
    </script>



       <div class="chart-and-note">
        <canvas id="statsChart"></canvas>
        <div class="sticky-note">
            <textarea id="noteText" placeholder="Write your note here..."></textarea>
            <button onclick="saveNote()">Save</button>
        </div>   </div>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


    <script>
        const ctx = document.getElementById('statsChart').getContext('2d');

        // Fetching values from PHP
        const globalProfit = <?php echo number_format($results['global_profit_query']['total_profit'], 2); ?>;
        const takeHomeProfit = <?php echo number_format($results['take_home_profit_query']['take_home_profit'], 2); ?>;
        const globalBalance = <?php echo number_format($results['global_balance_query']['total_balance'], 2); ?>;
        const tradersOnline = <?php echo number_format($results['traders_online_query']['total_online']); ?>;
        const totalInvested = <?php echo number_format($results['total_invested_query']['total_invested'], 2); ?>;
        const totalInvestors = <?php echo number_format($results['total_investors_query']['total_investors']); ?>;

        const statsChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['Global Profit', 'Take Home Profit', 'Global Balance', 'Minions Online', 'Total Invested', 'Total Minions'],
                datasets: [{
                    label: 'Financial Statistics (£)',
                    data: [globalProfit, takeHomeProfit, globalBalance, tradersOnline, totalInvested, totalInvestors],
                    backgroundColor: [
                        '#d4af37', // Creamy gold
                        '#b2ac8a', // Light gold
                        '#6f6242', // Bronze tone
                        '#d7d1ac', // Beige
                        '#1e3a3a', // Deep teal
                        '#093c31'  // Dark green
                    ],
                    borderColor: [
                        '#d4af37',
                        '#b2ac8a',
                        '#6f6242',
                        '#d7d1ac',
                        '#1e3a3a',
                        '#093c31'
                    ],
                    borderWidth: 2
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            color: '#d4af37' // Creamy gold for labels
                        },
                        grid: {
                            color: '#333' // Darker grid color to match theme
                        }
                    },
                    x: {
                        ticks: {
                            color: '#d4af37' // Creamy gold for labels
                        },
                        grid: {
                            color: '#333' // Darker grid color to match theme
                        }
                    }
                },
                plugins: {
                    legend: {
                        labels: {
                            color: '#d4af37' // Creamy gold for legend
                        }
                    }
                },
                backgroundColor: '#121212'
            }
        });
    </script>
</div>

<div class="r2">


    <?php include 'statistics.php'; ?>


<script>
function refreshStatistics() {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', 'statistics.php?action=fetch_stats', true);
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4 && xhr.status === 200) {
            var data = JSON.parse(xhr.responseText);
            document.getElementById('global_profit').textContent = parseFloat(data.global_profit).toFixed(2);
            document.getElementById('take_home_profit').textContent = parseFloat(data.take_home_profit).toFixed(2);
            document.getElementById('global_balance').textContent =  parseFloat(data.global_balance).toFixed(2);
            document.getElementById('traders_online').textContent = parseInt(data.traders_online, 10);
            document.getElementById('total_invested').textContent = parseFloat(data.total_invested).toFixed(2);
            document.getElementById('total_investors').textContent = parseInt(data.total_investors, 10);

        }
    };
    xhr.send();
}

// Refresh every 10 seconds
setInterval(refreshStatistics, 10000);
</script>

</div>

<center>

<br>

</div>


</body>
</html>